/****************************************************************
* Donohue and Wolfers (2006) 
* Table 1
* Estimating How Changes in Death Penalty Laws Effect Murder:
* Selected Before and After Comparisons: 1960-2000
****************************************************************/

cd "..."
use "UCR 1960-2003.dta", clear
set more off

drop if st=="US"
rename murderandnonnegligentmanslaught murders
rename murderrate murdrate
egen stid=group(st)
tsset stid year

gen legal=1
replace legal=0 if st=="MI" & year>=1846
replace legal=0 if st=="RI" & year>=1852
replace legal=0 if st=="WI" & year>=1853
replace legal=0 if st=="IA" & year>=1872 & year<1878
replace legal=0 if st=="ME" & year>=1876 & year<1883
replace legal=0 if st=="ME" & year>=1887
replace legal=0 if st=="CO" & year>=1897 & year<1901
replace legal=0 if st=="KS" & year>=1907 & year<1935
replace legal=0 if st=="MN" & year>=1911
replace legal=0 if st=="WA" & year>=1913 & year<1919
replace legal=0 if st=="OR" & year>=1914 & year<1920
* replace legal=0 if st=="ND" & year>=1915
replace legal=0 if st=="SD" & year>=1915 & year<1939
replace legal=0 if st=="TN" & year>=1915 & year<1916
replace legal=0 if st=="AZ" & year>=1916 & year<1918
replace legal=0 if st=="MO" & year>=1917 & year<1919
replace legal=0 if st=="AK" & year>=1957
replace legal=0 if st=="HI" & year>=1957
replace legal=0 if st=="DE" & year>=1958 & year<1961
replace legal=0 if st=="OR" & year>=1964
replace legal=0 if st=="IA" & year>=1965
replace legal=0 if st=="WV" & year>=1965
replace legal=0 if st=="VT" & year>=1965
replace legal=0 if st=="NY" & year>=1965
replace legal=0 if st=="NM" & year>=1969
replace legal=0 if st=="NH" & year>=1972 /* Court decision */
replace legal=0 if st=="CA" & year>=1972 /* Court decision */
replace legal=0 if year>=1972
replace legal=1 if st=="RI" & year>=1977 & year<1984
replace legal=1 if st=="MA" & year>=1982 & year<1984
replace legal=1 if st=="AL" & year>=1976
replace legal=1 if st=="AZ" & year>=1973
replace legal=1 if st=="AR" & year>=1973
replace legal=1 if st=="CA" & year>=1977
replace legal=1 if st=="CO" & year>=1975
replace legal=1 if st=="CT" & year>=1973
replace legal=1 if st=="DE" & year>=1974
replace legal=1 if st=="FL" & year>=1972
replace legal=1 if st=="GA" & year>=1973
replace legal=1 if st=="ID" & year>=1973
replace legal=1 if st=="IL" & year>=1974
replace legal=1 if st=="IN" & year>=1973
replace legal=1 if st=="KS" & year>=1994
replace legal=1 if st=="KY" & year>=1975
replace legal=1 if st=="LA" & year>=1973
replace legal=1 if st=="MD" & year>=1975
replace legal=1 if st=="MS" & year>=1974
replace legal=1 if st=="MO" & year>=1975
replace legal=1 if st=="MT" & year>=1974
replace legal=1 if st=="NE" & year>=1973
replace legal=1 if st=="NV" & year>=1973
replace legal=1 if st=="NH" & year>=1991
replace legal=1 if st=="NJ" & year>=1982
replace legal=1 if st=="NM" & year>=1979
replace legal=1 if st=="NY" & year>=1995
replace legal=1 if st=="NC" & year>=1977
replace legal=1 if st=="OH" & year>=1974
replace legal=1 if st=="OK" & year>=1973
replace legal=1 if st=="OR" & year>=1978
replace legal=1 if st=="PA" & year>=1974
replace legal=1 if st=="SC" & year>=1974
replace legal=1 if st=="SD" & year>=1979
replace legal=1 if st=="TN" & year>=1974
replace legal=1 if st=="TX" & year>=1974
replace legal=1 if st=="UT" & year>=1973
replace legal=1 if st=="VA" & year>=1975
replace legal=1 if st=="WA" & year>=1975
replace legal=1 if st=="WY" & year>=1977
replace legal=0 if year>=1972 & year<1976

gen abolitionist=0
for any AK HI ME MI MN WI: replace abolitionist=1 if st=="X"
egen absmurds=sum(murders), by(abolitionist year)
egen abspop=sum(pop), by(abolitionist year)
gen absmurdrate=100000*absmurds/abspop
egen abstag=tag(abolitionist year)

*Death Penalty Abolitions
sort st year
gen abolish=(legal[_n-1]==1 & legal==0)
replace abolish=1 if st=="FL" & year==1972
sort stid year
gen ab1=(f1.murdrate/l1.murdrate)-1 if abolish==1 & year>=1960 & year<=2000
gen ab2=((f1.murdrate+f2.murdrate)/(l1.murdrate+l2.murdrate))-1 if abolish==1 & year>=1960 & year<=2000
gen ab3=((f1.murdrate+f2.murdrate+f3.murdrate)/(l1.murdrate+l2.murdrate+l3.murdrate))-1 if abolish==1 & year>=1960 & year<=2000
gen absample1=ab1~=. & st~="VT" & st~="SD"
gen absample2=ab2~=. & st~="VT"
gen absample3=ab3~=. & st~="VT"
for num 1/3: inspect abX \ summ abX, det \ reg abX if absampleX==1

* Now generate controls: Only part of not if you aren't also in treatment
egen usmurders=sum(murders), by(year)
egen uspop=sum(pop), by(year)
gen abmurd=murders if abolish==1
gen abpop=pop if abolish==1
egen usabmurd=sum(abmurd), by(year)
egen usabpop=sum(abpop), by(year)
gen notabmurdrate=(usmurders-usabmurd)/(uspop-usabpop)
gen notab1=(f1.notabmurdrate/l1.notabmurdrate)-1 if abolish==1 & year>=1960 & year<=2000
gen notab2=((f1.notabmurdrate+f2.notabmurdrate)/(l1.notabmurdrate+l2.notabmurdrate))-1 if abolish==1 & year>=1960 & year<=2000
gen notab3=((f1.notabmurdrate+f2.notabmurdrate+f3.notabmurdrate)/(l1.notabmurdrate+l2.notabmurdrate+l3.notabmurdrate))-1 if abolish==1 & year>=1960 & year<=2000
for num 1/3: inspect notabX \ summ notabX, det \ reg notabX if absampleX==1
for num 1/3: ttest abX==notabX if absampleX==1, unpaired

*Death Penalty Reinstatements
gen reinstate=(legal[_n-1]==0 & legal==1)
sort stid year
gen re1=(f1.murdrate/l1.murdrate)-1 if reinstate==1 & year>=1960 & year<=2000
gen re2=((f1.murdrate+f2.murdrate)/(l1.murdrate+l2.murdrate))-1 if reinstate==1 & year>=1960 & year<=2000
gen re3=((f1.murdrate+f2.murdrate+f3.murdrate)/(l1.murdrate+l2.murdrate+l3.murdrate))-1 if reinstate==1 & year>=1960 & year<=2000
replace re2=. if st=="MA" | (st=="DE" & year==1961)
replace re3=. if st=="MA" | (st=="DE" & year==1961)
for num 1/3: gen resampleX=reX~=.
for num 1/3: inspect reX \ summ reX, det \ reg reX if resampleX==1

* Now generate controls: States not being treated in that year
gen remurd=murders if reinstate==1
gen repop=pop if reinstate==1
egen usremurd=sum(remurd), by(year)
egen usrepop=sum(repop), by(year)
gen notremurdrate=(usmurders-usremurd)/(uspop-usrepop)
gen notre1=(f1.notremurdrate/l1.notremurdrate)-1 if reinstate==1 & year>=1960 & year<=2000
gen notre2=(f1.notremurdrate+f2.notremurdrate)/(l1.notremurdrate+l2.notremurdrate)-1 if reinstate==1 & year>=1960 & year<=2000
gen notre3=(f1.notremurdrate+f2.notremurdrate+f3.notremurdrate)/(l1.notremurdrate+l2.notremurdrate+l3.notremurdrate)-1 if reinstate==1 & year>=1960 & year<=2000
replace notre2=. if st=="MA" | (st=="DE" & year==1961)
replace notre3=. if st=="MA" | (st=="DE" & year==1961)
for num 1/3: inspect notreX \ summ notreX, det \ reg notreX if resampleX==1
for num 1/3: ttest reX==notreX if resampleX==1, unpaired

program drop _all
program define diffinmed
	version 9.0
	tempname med1
	tempname med2
	summ `1', det
	gen med1=r(p50)
	summ `2', det
	gen med2=r(p50)
	gen diff=med1-med2
	summ diff
end

set seed 1
for num 1/3: summ abX notabX, det \ preserve \ drop if abX==. & notabX==. \ bootstrap diffinmedabX=r(mean), reps(10000) nodots: diffinmed abX notabX \ restore
for num 1/3: summ reX notreX, det \ preserve \ drop if reX==. & notreX==. \ bootstrap diffinmedreX=r(mean), reps(10000) nodots: diffinmed reX notreX \ restore

